﻿using System;

namespace CSharpBuch.Kap05
{
  class Aufgabe2
  {
    static void Main(string[] args)
    {
      Bruch b1 = new Bruch(3, 4);
      Bruch b2 = new Bruch(7, 5);
      Bruch b3 = b1 + b2;
      Console.WriteLine(b1.ToString() + " + " + b2.ToString() + " = " + b3.ToString());
      b3 = b1 - b2;
      Console.WriteLine(b1.ToString() + " - " + b2.ToString() + " = " + b3.ToString());
      b3 = b1 * b2;
      Console.WriteLine(b1.ToString() + " * " + b2.ToString() + " = " + b3.ToString());
      b3 = b1 / b2;
      Console.WriteLine(b1.ToString() + " / " + b2.ToString() + " = " + b3.ToString());

      Console.ReadLine();
    }
  }

  public class Bruch
  {
    private int zaehler;
    private int nenner;

    public Bruch(int zaehler, int nenner)
    {
      this.zaehler = zaehler;
      this.nenner = nenner;
    }

    public int getZaehler()
    {
      return zaehler;
    }

    public int getNenner()
    {
      return nenner;
    }

    public static Bruch operator +(Bruch op1, Bruch op2)
    {
      int nenner = op1.nenner * op2.nenner;
      int zaehler = nenner / op1.nenner * op1.zaehler +
                    nenner / op2.nenner * op2.zaehler;
      Bruch b = new Bruch(zaehler, nenner);
      return b;
    }

    public static Bruch operator -(Bruch op1, Bruch op2)
    {
      int nenner = op1.nenner * op2.nenner;
      int zaehler = nenner / op1.nenner * op1.zaehler -
                    nenner / op2.nenner * op2.zaehler;
      Bruch b = new Bruch(zaehler, nenner);
      return b;
    }

    public static Bruch operator *(Bruch op1, Bruch op2)
    {
      int nenner = op1.nenner * op2.nenner;
      int zaehler = op1.zaehler * op2.zaehler;
      Bruch b = new Bruch(zaehler, nenner);
      return b;
    }

    public static Bruch operator /(Bruch op1, Bruch op2)
    {
      int nenner = op1.nenner * op2.zaehler;
      int zaehler = op1.zaehler * op2.nenner;
      Bruch b = new Bruch(zaehler, nenner);
      return b;
    }

    public override string ToString()
    {
      return zaehler.ToString() + "/" + nenner.ToString();
    }
  }
}